module.exports = {
  shuffle: (array) => {
    var currentIndex = array.length, temporaryValue, randomIndex

    // While there remain elements to shuffle...
    while (0 !== currentIndex) {

      // Pick a remaining element...
      randomIndex = Math.floor(Math.random() * currentIndex)
      currentIndex -= 1

      // And swap it with the current element.
      temporaryValue = array[currentIndex]
      array[currentIndex] = array[randomIndex]
      array[randomIndex] = temporaryValue
    }

    return array
  }, waitFor: async (ms) => {
    return new Promise(resolve => {
      setTimeout(resolve, ms)
    })
  },
  randomInt: (max) => {
    return Math.floor(Math.random() * Math.floor(max))
  },
  removeFromArray(original, remove) {
    return original.filter(value => !remove.includes(value))
  },
  sortObjectParams(list) {
    return Object.keys(list).sort(function (a, b) { return list[a] - list[b] }).map(Number)
  },
  isEmpty: (input) => {
    return input.replace(" ", "") == ""
  }
}


