/**
 * @preserve
 * Copyright 2015-2016 Igor Bezkrovnyi
 * All rights reserved. (MIT Licensed)
 *
 * iq.ts - Image Quantization Library
 */
import { AbstractDistanceCalculator } from "./abstractDistanceCalculator"
import { CIE94Textiles, CIE94GraphicArts } from "./cie94"
import { CIEDE2000 } from "./ciede2000"
import { CMETRIC } from "./cmetric"
import { AbstractEuclidean, Euclidean, EuclideanRgbQuantWOAlpha, EuclideanRgbQuantWithAlpha } from "./euclidean"
import { AbstractManhattan, Manhattan, ManhattanSRGB, ManhattanNommyde } from "./manhattan"
import { PNGQUANT } from "./pngQuant"

export {
    AbstractDistanceCalculator,
    CIE94Textiles,
    CIE94GraphicArts,
    CIEDE2000,
    CMETRIC,
    PNGQUANT,

    AbstractEuclidean,
    Euclidean,
    EuclideanRgbQuantWithAlpha,
    EuclideanRgbQuantWOAlpha,

    AbstractManhattan,
    Manhattan,
    ManhattanSRGB,
    ManhattanNommyde
}
